﻿/*
 * ----------------------------------------------------
 * Copyright (c) 有栖かずみ / Arisu Kazumi
 * This software is released under the MIT license.
 * http://opensource.org/licenses/mit-license.php
 * ----------------------------------------------------
 */

/*:
 * @plugindesc 敵ごとに撃破時のメッセージを設定
 * @target MZ
 * @author 有栖かずみ
 * @url https://a-kazumi.com/plugins
 * @help 敵ごとに撃破時に表示されるメッセージを設定できます。
 *
 * 例えば、スライムという敵キャラを倒したときに、
 * 「スライムAをやっつけた！」（1行目）
 * 「おとなしくなったスライムAは去っていった！」（2行目）
 * のようなメッセージをバトルログに表示できます（1行だけも可能）。
 *
 * ■使い方■
 * まず、元々の「〇〇を倒した！」というメッセージの設定を空欄にしてください。
 * （データベース→ステート→0001 戦闘不能
 * 　→メッセージの「敵キャラがこの状態になったとき:」の欄です）
 *
 * 次に、データベースの敵キャラのメモ欄に表示したいメッセージを書きます。
 * <DefeatMessage1:\NAMEをやっつけた！>
 * <DefeatMessage2:おとなしくなった\NAMEは去っていった！>
 * のように書いてください。
 *
 * 「\NAME」が敵キャラ名に置換されます。
 * <DefeatMessage2>を記載しなければ2行目は表示されません。
 * このメッセージは敵キャラごとに設定できます。
 *
 * なお、メモ欄にDefeatMessage1と2の記載が無い敵を倒したときには、
 * 一律で「〇〇を倒した！」という表記になります。
 *
 * 2024/02/18 ver1.0.3 URL表記を変更。文字コードをUTF-8のBOM付きに変更。プログラムは変更なし
 * 2024/02/06 ver1.0.2 公開用に細かい修正
 * 2023/10/22 ver1.0.1 ファイル名をKZM_EnemyDefeatLog.jsに変更
 * 2022/??/?? ver1.0.0 作成
 */

(() => {
    "use strict";

    Window_BattleLog.prototype.displayAddedStates = function (target) {
        const result = target.result();
        const states = result.addedStateObjects();
        for (const state of states) {
            const stateText = target.isActor() ? state.message1 : state.message2;
            if (state.id === target.deathStateId()) {
                this.push("performCollapse", target);
                //ここから追記
                if (!target.isActor()) {
                    const name = $gameTroop.members()[$gameTemp.lastActionData(5) - 1].name();
                    const id = $gameTroop.members()[$gameTemp.lastActionData(5) - 1].enemyId();
                    if ($dataEnemies[id].meta.DefeatMessage1 != undefined) {
                        const defeatMessage1 = $dataEnemies[id].meta.DefeatMessage1.replace(
                            "\\NAME",
                            name
                        );
                        BattleManager._logWindow.push("addText", defeatMessage1);
                    }
                    if ($dataEnemies[id].meta.DefeatMessage2 != undefined) {
                        const defeatMessage2 = $dataEnemies[id].meta.DefeatMessage2.replace(
                            "\\NAME",
                            name
                        );
                        BattleManager._logWindow.push("addText", defeatMessage2);
                    }
                    if (
                        !$dataEnemies[id].meta.DefeatMessage1 &&
                        !$dataEnemies[id].meta.DefeatMessage2
                    ) {
                        BattleManager._logWindow.push("addText", name + "を倒した！");
                    }
                }
                //ここまで追記
            }
            if (stateText) {
                this.push("popBaseLine");
                this.push("pushBaseLine");
                this.push("addText", stateText.format(target.name()));
                this.push("waitForEffect");
            }
        }
    };
})();
